
-- In Memory, pas possible avec Express

USE BD_Air_France;

IF OBJECT_ID ('dbo.P_ajoute_aero','U') IS NOT NULL
    DROP PROCEDURE dbo.P_ajoute_aero;
GO

IF OBJECT_ID ('dbo.T_aeroport_aer','U') IS NOT NULL
    DROP TABLE T_aeroport_aer;
GO

-- 336, 7-45

CREATE TABLE T_aeroport_aer
 (aer_IATA   VARCHAR(3) NOT NULL,
  aer_OACI   VARCHAR(6) NOT NULL,
  aer_nom    VARCHAR(50),
  aer_creation DATE,
  CONSTRAINT PK_aer PRIMARY KEY NONCLUSTERED HASH (aer_IATA) WITH (BUCKET_COUNT=1000))
WITH (MEMORY_OPTIMIZED=ON, DURABILITY=SCHEMA_AND_DATA)
GO

CREATE PROCEDURE P_ajoute_aero(@p1 VARCHAR(3), @p2 VARCHAR(6), @p3 VARCHAR(50))
WITH NATIVE_COMPILATION, SCHEMABINDING, EXECUTE AS OWNER
AS 
BEGIN ATOMIC WITH
(TRANSACTION ISOLATION LEVEL = SNAPSHOT,LANGUAGE = N'French')
  DECLARE @date_jour DATE = GETDATE();
  INSERT INTO dbo.T_aeroport_aer(aer_IATA, aer_OACI, aer_nom,aer_creation) 
   VALUES (@p1,@p2,@p3,@date_jour);
-- pas possible  ROLLBACK;
END;
GO

DECLARE @iata VARCHAR(3);
DECLARE @oaci VARCHAR(6);
DECLARE @aero VARCHAR(50) ;

SET  @iata  = 'TLS';
SET  @oaci  = 'LFBO';
SET @aero = 'Toulouse Blagnac';
EXEC P_ajoute_aero @iata,@oaci,@aero;

SET  @iata  = 'ORY';
SET  @oaci  = 'LFPO';
SET  @aero = NULL;

EXEC P_ajoute_aero @iata,@oaci,@aero;

SELECT * FROM  T_aeroport_aer;

IF OBJECT_ID ('dbo.P_ajoute_aero','U') IS NOT NULL
    DROP PROCEDURE dbo.P_ajoute_aero;
GO
IF OBJECT_ID ('dbo.T_aeroport_aer','U') IS NOT NULL
    DROP TABLE T_aeroport_aer;
GO